% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneInfo.R
\name{getGeneInfoByEntrez}
\alias{getGeneInfoByEntrez}
\title{Gene information for given list of gene Entrez IDs}
\usage{
getGeneInfoByEntrez(entrez)
}
\arguments{
\item{entrez}{\code{vector} of Entres IDs. Function accepts both
integers and characters.}
}
\value{
\code{data.frame}  with fields specified above.
}
\description{
Get gene information for set of gene Entrez IDs. Function lookup for
name in Human Entrez ID and Mouse Entrez Id  data and return following
features for all found genes: GeneID (internal database ID), Localisation
(presynaptic, postsynaptic, synaptosome), MGI (MGI ID),
HumanEntrez (Human Entrez ID), MouseEntrez (Mouse Entrez ID),
HumanName (Human gene name), MouseName (Mouse gene name),
PaperPMID (PMID IDs for the publications where the genes were reported),
Paper (papers where specific genes were reported in a format
FIRSTAUTHOR_YEAR), Year, SpeciesTaxID (specie the original experiment
was performed on), BrainRegion (Brain region where the specific genes
were identified, according to the paper)
}
\examples{
# get information for specific gene
t <- getGeneInfoByEntrez(1742)
# get information for specific character string Entres representation
t <- getGeneInfoByEntrez("1742")

# get information for the list of genes
t <- getGeneInfoByName(c(1741, 1742, 1739, 1740))
}
\seealso{
Other {GeneInfo functions}: 
\code{\link{getGeneInfoByIDs}()},
\code{\link{getGeneInfoByName}()},
\code{\link{getGeneInfoByPapers}()}
}
\concept{{GeneInfo functions}}
