% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{graphFromSynaptomeGeneTable}
\alias{graphFromSynaptomeGeneTable}
\title{Utility function to create network from
\code{\link{synaptome.db}} data}
\usage{
graphFromSynaptomeGeneTable(
  geneTable,
  LCC = FALSE,
  simplify = FALSE,
  type = c("limited", "induced")
)
}
\arguments{
\item{geneTable}{data.frame described in
\code{\link{getGenesByID}}}

\item{LCC}{if TRUE only largest connected component is returned}

\item{simplify}{if TRUE loops and multiple edges will be removed}

\item{type}{type of the PPI network should be either `induced` (for
all the PPIs for specific genes, including external genes) or
`limited` (for PPIs between the genes specified in the query).
Type could be shortened to recognizable minimum like 'ind'
or 'lim'.}
}
\value{
network defined by the gene table
}
\description{
Utility function to create network from
\code{\link{synaptome.db}} data
}
\examples{
library(synaptome.db)
cid<-match('Presynaptic', getCompartments()$Name)
geneTable<-getAllGenes4Compartment(cid)
gg<-graphFromSynaptomeGeneTable(geneTable)
}
\seealso{
[getPPIbyIDs()]
}
