% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetResultsObj.R
\name{GetResultsObj}
\alias{GetResultsObj}
\title{Get a Results Object}
\usage{
GetResultsObj(strainID, geneSource = "Prodigal")
}
\arguments{
\item{strainID}{Character string corresponding to the strain identifier.}

\item{geneSource}{Character string corresponding to the gene source.}
}
\value{
An object of class \code{Assessment} and subclass \code{Results}
}
\description{
Gets and returns the results object for a specific strain-gene source combo
}
\details{
\code{GetDataMapObj} returns an object of class \code{Assessment} and subclass
\code{Results} corresponding to the given strain ID and the given gene source. The given
strain ID must be a part of the AssessORF set, and there is no partial matching. Otherwise,
the function will error. The given gene source must also be a part of the AssessORF set, but
the function ignores case when checking if the given gene source is a part of the set.
}
\examples{

resObj1 <- GetResultsObj("MGAS5005", "Prodigal")
resObj2 <- GetResultsObj("MGAS5005", "GenBank")
resObj3 <- GetResultsObj("MGAS5005", "GeneMarkS2")
resObj4 <- GetResultsObj("MGAS5005", "Glimmer")

}
