% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaveGenomeToPath.R
\name{SaveGenomeToPath}
\alias{SaveGenomeToPath}
\title{Save a Strain's Genome to a Directory}
\usage{
SaveGenomeToPath(strainID, filePath)
}
\arguments{
\item{strainID}{Character string corresponding to the strain identifier.}

\item{filePath}{Character string corresponding to the path to the file path.
Must end in '.fasta'.}
}
\value{
Invisibly returns \code{filePath}
}
\description{
Saves the genome for a specified strain to a given directory
}
\details{
\code{SaveGenomeToPath} saves the genome for the specified strain ID to the given
file path. If the file specified by the path already exists, it will be overwitten (with a
warning). The given strain ID must be a part of the AssessORF set, and there is no partial
matching. Otherwise, the function will error.

Note: there is no genome for strain ATCC700084, so a reference genome for the species
(strain MC2155) is used instead.
}
\examples{

tmpFile <- paste0(tempfile(), ".fasta")
SaveGenomeToPath("MGAS5005", tmpFile)
unlink(tmpFile)

}
