% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioplex.R
\name{getBioPlex}
\alias{getBioPlex}
\title{Obtain BioPlex protein-protein interaction data}
\usage{
getBioPlex(
  cell.line = c("293T", "HCT116"),
  version = c("3.0", "1.0", "2.0"),
  remap.uniprot.ids = FALSE,
  cache = TRUE
)
}
\arguments{
\item{cell.line}{character. Valid options include:
\itemize{
\item \code{"293T"}: derivative of human embryonic kidney 293 cell line,
\item \code{"HCT116"}: human colon cancer cell line 116.
}
Defaults to \code{"293T"}.}

\item{version}{character. Valid options include \code{"1.0"}, \code{"2.0"},
and \code{"3.0"} for 293T cells. For HCT116 cells, only \code{"1.0"} is
available.
Defaults to \code{"3.0"}.}

\item{remap.uniprot.ids}{logical. Should the protein-to-gene mappings from BioPlex
(i.e. UNIPROT-to-SYMBOL and UNIPROT-to-ENTREZID) be updated using Bioc annotation
functionality?
Defaults to \code{FALSE} which will then keep the mappings provided by BioPlex.}

\item{cache}{logical. Should a locally cached version used if available?
Defaults to \code{TRUE}.}
}
\value{
A \code{data.frame}.
}
\description{
Functionality for retrieving the BioPlex protein-protein
interaction data. Available networks include:
\itemize{
\item BioPlex 293T cells (versions 1.0, 2.0, and 3.0),
\item BioPlex HCT116 cells (version 1.0).
} See references.
}
\examples{
# (1) Obtain the latest version of the 293T PPI network
bp.293t <- getBioPlex(cell.line = "293T", version = "3.0")

# (2) Obtain the latest version of the HCT116 PPI network
bp.hct116 <- getBioPlex(cell.line = "HCT116", version = "1.0")
}
\references{
BioPlex: \url{https://bioplex.hms.harvard.edu/interactions.php}
}
