\name{DB_GPL1261.bigmemory}
\alias{DB_GPL1261.bigmemory}
\docType{data}
\title{
Database of gene expression profiles from the Affymetrix Mouse 430 2.0 Array (GPL1261) in big.matrix format
}
\description{
The data set contains 9634 mouse profiles downloaded from NCBI GEO, processed using fRMA, and normalized. It is in big.matrix format.
}
\format{
  The format is:
Formal class 'big.matrix' [package "bigmemory"] with 1 slots
  ..@ address:<externalptr>
}
\details{
The database is formatted as a big.matrix for more efficient loading into memory. It is stored in DB_GPL1261.bigmemory and the corresponding description file is DB_GPL1261.bigmemory.desc. To utilize the big.matrix format, it requires the package bigmemory to be loaded. See the bigmemory package for more information.

The database contains 20757 rows and 9643 columns. Each row represents the expression vector for each gene and each column represents the gene expression measurements for a sample from NCBI GEO obtained using the GPL1261 platform. Each gene will match uniquely to a single probe ID; only the probe with the highest variance in the compendium apriori to normalization are retained as the representative measurement for each gene.

}
\source{
www.ncbi.nlm.nih.gov/geo/
}
\references{
McCall M.N., Bolstad B.M., and Irizarry R.A. (2010) Frozen robust multiarray analysis (fRMA). Biostatistics 11, 242-253.

Barrett T., et al. (2007) NCBI GEO: mining tens of millions of expression profiles - database and tools update. Nucl. Acids Res. 35, D760-D765.
}
\examples{
## Load the GPL1261 database
library(bigmemory)
path <- system.file("extdata",package="ChIPXpressData")
DB_GPL1261 <- attach.big.matrix("DB_GPL1261.bigmemory.desc",path=path)
## DB_GPL1261 is then ready for input into the ChIPXpress function.

## To see info about the database matrix
describe(DB_GPL1261)
}
\keyword{datasets,GPL1261,database}
