% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoSIAdata-package.R
\docType{package}
\name{CoSIAdata}
\alias{CoSIAdata}
\alias{_PACKAGE}
\title{CoSIAdata: VST normalized RNA-Sequencing data with annotations for multiple species samples from Bgee}
\format{
Multiple dataframes
}
\description{
CoSIAdata includes Variance Stabilized Transformation of Read Counts from
Bgee RNA-Seq Expression Data across six species (Homo sapiens, Mus musculus,
Rattus norvegicius,Danio rerio, Drosophila melanogaster, and Caenorhabditis
elegans) and more than 132 tissues. Each species has its own independent
dataframe with its unique set of tissue and gene specific expression data.

CoSIAdata is meant to be integrated into the CoSIA Package, a visualization
tool for cross species comparison of expression metrics. However, it can be
used to conduct independent species, tissue, and gene-specific
expression analysis.

Researchers might find this data useful as it provides Variance Stabilized
Transformation of read counts to compare RNA-Seq expression profiles.
}
\examples{
library(ExperimentHub)
eh <- ExperimentHub()
query(eh, "CoSIAdata")
eh[["EH7863"]]
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/lasseignelab/CoSIAdata/issues}
}

}
\author{
\strong{Maintainer}: Amanda D. Clark \email{amanda@freshairfamily.org} (\href{https://orcid.org/0000-0002-1186-3114}{ORCID})

Authors:
\itemize{
  \item Anisha Haldar (\href{https://orcid.org/0000-0002-1395-9793}{ORCID})
  \item Vishal H. Oza (\href{https://orcid.org/0000-0001-6990-0267}{ORCID})
  \item Nathaniel S. DeVoss (\href{https://orcid.org/0000-0003-0465-2770}{ORCID})
  \item Brittany N. Lasseigne (\href{https://orcid.org/0000-0002-1642-8904}{ORCID})
}

}
\keyword{internal}
