#' HCAData: Accessing The Datasets Of The Human Cell Atlas in R/Bioconductor
#'
#' `HCAData` is an ExperimentHub package which provides access to the single-cell
#' RNA-seq data from the Human Cell Atlas project (<https://www.humancellatlas.org>)
#'
#' @references If you use the data in this package, please refer to the original sources
#' (Human Cell Atlas Data Portal, <https://preview.data.humancellatlas.org>) as well
#' (plus the related publications, which will be listed here when they will be out),
#' which are licensed under a Creative Commons Attribution 4.0 International License.
#'
#' @importFrom utils read.csv
#' @importFrom ExperimentHub createHubAccessors ExperimentHub
#' @importFrom AnnotationHub query
#' @importFrom HDF5Array HDF5Array
#' @importFrom SingleCellExperiment SingleCellExperiment
#'
#' @author Federico Marini \email{marinif@@uni-mainz.de}
#' @name HCAData-pkg
#' @keywords internal
"_PACKAGE"
