% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{wasserman_normal_prds_sim}
\alias{wasserman_normal_prds_sim}
\alias{wasserman_normal_prds_sim_fun}
\title{Normal PRDS simulation: Covariate is effect size under alternative, there are latent factors
     driving PRDS correlations among hypotheses}
\usage{
wasserman_normal_prds_sim(
  m,
  pi0,
  rho = 0,
  latent_factors = 1,
  xi_min = 0,
  xi_max = 2.5,
  seed = NULL
)

wasserman_normal_prds_sim_fun(
  m,
  pi0,
  rho = 0,
  latent_factors = 1,
  xi_min = 0,
  xi_max = 2.5
)
}
\arguments{
\item{m}{Integer, total number of hypotheses}

\item{pi0}{Numeric, proportion of null hypotheses}

\item{rho}{Numeric, correlation between z-scores of hypotheses driven by same latent factor}

\item{latent_factors}{Integer, number of latent factors driving the correlations}

\item{xi_min, xi_max}{Numeric, covariates are drawn as uniform on xi_min, xi_max}

\item{seed}{Integer, Random seed to be used for simulation 
(default: NULL, i.e. RNG state will be used as is)}
}
\value{
A data frame containing all information about the simulation experiment
}
\description{
Normal PRDS simulation: Covariate is effect size under alternative, there are latent factors
     driving PRDS correlations among hypotheses
}
\section{Functions}{
\itemize{
\item \code{wasserman_normal_prds_sim_fun}: Creates a closure function for a given seed
}}

\examples{
sim_df <- wasserman_normal_prds_sim(20000,0.9, rho=0.1)

}
