% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HumanPrimaryCellAtlasData.R
\name{HumanPrimaryCellAtlasData}
\alias{HumanPrimaryCellAtlasData}
\title{Obtain the HPCA data}
\usage{
HumanPrimaryCellAtlasData(
  ensembl = FALSE,
  cell.ont = c("all", "nonna", "none"),
  legacy = FALSE
)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether to convert row names to Ensembl IDs.
Genes without a mapping to a non-duplicated Ensembl ID are discarded.}

\item{cell.ont}{String specifying whether Cell Ontology terms should be included in the \code{\link{colData}}.
If \code{"nonna"}, all samples without a valid term are discarded;
if \code{"all"}, all samples are returned with (possibly \code{NA}) terms;
if \code{"none"}, terms are not added.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \linkS4class{SummarizedExperiment} object with a \code{"logcounts"} assay
containing the log-normalized expression values, along with cell type labels in the 
\code{\link{colData}}.
}
\description{
Download and cache the normalized expression values of the data stored in
the Human Primary Cell Atlas. The data will be downloaded from ExperimentHub,
returning a \linkS4class{SummarizedExperiment} object for further use.
}
\details{
This function provides normalized expression values for 713 microarray samples from
the Human Primary Cell Atlas (HPCA) (Mabbott et al., 2013).
These 713 samples were processed and normalized as described in Aran, Looney and 
Liu et al. (2019).

Each sample has been assigned to one of 37 main cell types (\code{"label.main"}) 
and 157 subtypes (\code{"label.fine"}).
The subtypes have also been mapped to the Cell Ontology (\code{"label.ont"}, 
if \code{cell.ont} is not \code{"none"}), which can be used for further programmatic
queries.
}
\examples{
ref.se <- HumanPrimaryCellAtlasData()

}
\references{
Mabbott NA et al. (2013).
An expression atlas of human primary cells: inference of gene function from coexpression networks.
\emph{BMC Genomics} 14, Article 632. 

Aran D, Looney AP, Liu L et al. (2019). 
Reference-based analysis of lung single-cell sequencing reveals a transitional profibrotic macrophage.
\emph{Nat. Immunol.} 20, 163–172.
}
\author{
Friederike Dündar
}
