% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MouseRNAseqData.R
\name{MouseRNAseqData}
\alias{MouseRNAseqData}
\title{Obtain mouse bulk expression data of sorted cell populations (RNA-seq)}
\usage{
MouseRNAseqData(
  ensembl = FALSE,
  cell.ont = c("all", "nonna", "none"),
  legacy = FALSE
)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether to convert row names to Ensembl IDs.
Genes without a mapping to a non-duplicated Ensembl ID are discarded.}

\item{cell.ont}{String specifying whether Cell Ontology terms should be included in the \code{\link{colData}}.
If \code{"nonna"}, all samples without a valid term are discarded;
if \code{"all"}, all samples are returned with (possibly \code{NA}) terms;
if \code{"none"}, terms are not added.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \linkS4class{SummarizedExperiment} object with a \code{"logcounts"} assay
containing the log-normalized expression values, along with cell type labels in the 
\code{\link{colData}}.
}
\description{
Download and cache the normalized expression values of 358 bulk RNA-seq samples
of sorted cell populations that can be found at GEO.
}
\details{
This dataset was contributed by the Benayoun Lab that identified, 
downloaded and processed data sets on GEO that corresponded to sorted cell
types (Benayoun et al., 2019).

The dataset contains 358 mouse RNA-seq samples annotated to 18 main cell types (\code{"label.main"}):
\itemize{
    \item Adipocytes
    \item Astrocytes
    \item B cells 
    \item Cardiomyocytes
    \item Dendritic cells
    \item Endothelial cells
    \item Epithelial cells
    \item Erythrocytes
    \item Fibroblasts
    \item Granulocytes
    \item Hepatocytes
    \item Macrophages
    \item Microglia
    \item Monocytes
    \item Neurons
    \item NK cells
    \item Oligodendrocytes
    \item T cells
} 
These are split further into 28 subtypes (\code{"label.fine"}).
The subtypes have also been mapped to the Cell Ontology (\code{"label.ont"},
if \code{cell.ont} is not \code{"none"}), which can be used for further programmatic
queries.
}
\examples{
ref.se <- MouseRNAseqData()

}
\references{
Benayoun B et al. (2019).
Remodeling of epigenome and transcriptome landscapes with aging in mice reveals widespread induction of inflammatory responses.
\emph{Genome Res.} 29, 697-709.

Code at \url{https://github.com/BenayounLaboratory/Mouse_Aging_Epigenomics_2018/tree/master/FigureS7_CIBERSORT/RNAseq_datasets_for_Deconvolution/2017-01-18}
}
\author{
Friederike Dündar
}
