% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{curatedPCaDatasets_icgcca}
\alias{curatedPCaDatasets_icgcca}
\title{ICGC CA MAE-object}
\format{
An MAE object spanning 213 men with prostate cancer
\describe{
    \item{gex.rma}{matrix with 17208 rows and 213 columns, of gene expression
        data}
    \item{cibersort}{matrix with 22 rows and 213 columns, of cibersort based 
        deconvolution data}
    \item{xcell}{matrix with 39 rows and 213 columns, of xcell based 
        deconvolution data}
    \item{epic}{matrix with 8 rows and 213 columns, of epic based 
        deconvolution data}
    \item{quantiseq}{matrix with 11 rows and 213 columns, of quantiseq based 
        deconvolution data}
    \item{estimate}{data.frame with 4 rows and 213 columns, of cell types 
        based on ESTIMATE method}
    \item{scores}{matrix with 4 rows and 213 columns, of risk scores and AR 
        scores}
    \item{mcp}{matrix with 11 rows and 213 columns, of mcp-counter based 
        deconvolution data}
}
}
\source{
\url{https://dcc.icgc.org/projects/PRAD-CA}
}
\value{
A MultiAssayExperiment corresponding to the study and its available 
omics.
}
\description{
MultiAssayExperiment object containing gene expression (gex) and immune cell 
estimates for the ICGC CA (Canadian) cohort.
}
\details{
The data refers to samples from the ICGC Canadian Prostate Cancer 
Genome Network (ICGC-PRAD-CA)
}
\examples{
mae_icgcca <- getPCa('icgcca')
}
\references{
(\href{https://pubmed.ncbi.nlm.nih.gov/28068672/}{PubMed})
}
\keyword{datasets}
