% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curatedTBData.R
\name{curatedTBData}
\alias{curatedTBData}
\title{Import curated Tuberculosis Data}
\usage{
curatedTBData(study_name, dry.run = TRUE, curated.only = TRUE)
}
\arguments{
\item{study_name}{A character or vector of characters that contain name
of the studies. When \code{any(study_name == "") == TRUE},
the function will return all available studies.}

\item{dry.run}{Boolean. Indicate the whether downloading resources from the
ExperimentHub services.
If \code{TRUE} (Default), return the names of the available resources
to be downloaded. If \code{FALSE}, start downloading data.}

\item{curated.only}{Boolean. Indicate whether downloading resources
for the curated version.
If \code{TRUE} (Default), only download the curated gene expression
profile and the clinical annotation information
If \code{FALSE}, download both raw and curated resources.}
}
\value{
A \code{list} of
  \link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment}
  objects.
}
\description{
A function to access available curated tuberculosis transcriptomic data
  from the Bioconductor's ExperimentHub services
}
\examples{
curatedTBData("GSE39939", dry.run = TRUE)
curatedTBData(c("GSE39939", "GSE39940"), dry.run = FALSE, curated.only = TRUE)
}
