\name{syntren1000.data}
\docType{data}
\alias{syntren1000.data}
\title{Simulated Gene Expression Data}
\description{
    Dataset containing 1000 samples and 1000 genes generated by the publicly 
    available SynTReN generator using an ecoli source network. 
}
\usage{data(syntren1000.data)}
\format{
    \code{syntren1000.data} is a data frame containing 1000 rows 
    and 1000 columns. Each row contains a simulated microarray 
    experiment and each column contains a gene.
}
\source{
    SynTReN 1.1.3 with source network : ecoli\_nn.sif
}
\references{
    Van den Bulcke, Tim, et al. "SynTReN: a generator of synthetic gene 
    expression data for design and analysis of structure learning algorithms." 
    BMC Bioinformatics 7.1 (2006): 43.
}
\value{
    \code{data.frame} containg the data.
}
\seealso{
    \code{\link{gnw1565.data}}, \code{\link{gnw2000.data}}, 
    \code{\link{rogers1000.data}}, \code{\link{syntren300.data}}
}
\examples{
    data(syntren1000.data)
    # Print size
    print(dim(syntren1000.data))
}
\keyword{datasets}
