\name{leukemiasEset}
\docType{data}
\alias{leukemiasEset-package}
\alias{leukemiasEset}
\title{Leukemia's microarray gene expression data (expressionSet).}

\details{
\tabular{ll}{
Package: \tab leukemiasEset\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2013-03-13\cr
License: \tab GPL (>=2)\cr
LazyLoad: \tab yes\cr
}
}
\author{
Author: Sara Aibar, Celia Fontanillo and Javier De Las Rivas. Bioinformatics and Functional Genomics Group. Cancer Research Center (CiC-IBMCC, CSIC/USAL). Salamanca. Spain.

Maintainer: Sara Aibar <saibar@usal.es>
}
\description{
ExpressionSet containing gene expresion data from 60 bone marrow samples of patients with one of the four main types of leukemia (ALL, AML, CLL, CML) or no-leukemia controls.\cr

Platform: Affymetrix Human Genome U133 Plus 2.0\cr
Annotation: genemapperhgu133plus2 (CDF from GATExplorer)\cr
Mapping: Gene Ensembl ID (20172 features)\cr

Tissue: Bone Marrow\cr
Cell type: Mononuclear cells isolated by Ficoll density centrifugation\cr
Disease type: 
\enumerate{
\item Acute Lymphoblastic Leukemia (ALL). Subtype: c-ALL / pre-B-ALL without t(9;22)
\item Acute Myeloid Leukemia (AML). Subtype: Normal karyotype
\item Chronic Lymphocytic Leukemia (CLL)
\item Chronic Myeloid Leukemia (CML)
\item Non-leukemia and healthy bone marrow (NoL)
}
All samples were obtained from untreated patients at the time of diagnosis. 

Preprocessing: The microarrays were normalized with \code{\link[affy:rma]{RMA}} using a redefined probe mapping from \emph{Affymetrix} probesets to \emph{Ensembl} genes (Ensembl IDs ENSG).  This alternative Chip Definition File (CDF) with complete unambiguous mapping of microarray probes to genes (GeneMapper) is available at GATExplorer (\href{http://bioinfow.dep.usal.es/xgate/mapping/mapping.php?content=rprogram}{http://bioinfow.dep.usal.es/xgate/mapping/mapping.php}) \emph{(Risueno et al. 2010)}.
}
\source{
This is a subset of the samples collected by the Microarray Innovations in Leukemia (MILE) study \emph{(Kohlmann et al. 2008, Haferlach et al. 2010)}. Full study microarray raw data can be found at the NCBI Gene Expression Omnibus database (GEO, \href{http://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE13159}{http://www.ncbi.nlm.nih.gov/geo/}) under series accession number GSE13159. The selected samples are labelled keeping their source GEO IDs.\cr
}
\references{
\emph{Kohlmann A, Kipps TJ, Rassenti LZ, Downing JR et al}. An international standardization programme towards the application of gene expression profiling in routine leukaemia diagnostics: the Microarray Innovations in LEukemia study prephase. Br J Haematol (2008) 142(5):802-7. PMID: 18573112\cr

\emph{Haferlach T, Kohlmann A, Wieczorek L, Basso G et al}. Clinical utility of microarray-based gene expression profiling in the diagnosis and subclassification of leukemia: report from the International Microarray Innovations in Leukemia Study Group. J Clin Oncol (2010) 28(15):2529-37. PMID: 20406941\cr

\emph{Risueno A, Fontanillo C, Dinger ME, De Las Rivas J}. GATExplorer: genomic and transcriptomic explorer; mapping expression probes to gene loci, transcripts, exons and ncRNAs. BMC Bioinformatics (2010) 11:221. PMID: 20429936.
}

\format{
 \code{\link[Biobase:ExpressionSet]{ExpressionSet}} with phenoData: 
 \itemize{
 \item{Project: }{ "Mile1" for all samples }
 \item{Tissue: }{ "BoneMarrow"} 
 \item{LeukemiaType: }{ Leukemia type acronym: "ALL", "AML", "CLL", "CML" or "NoL"}
 \item{LeukemiaTypeFullName: }{ The full leukemia type name.}
 \item{Subtype: }{ "AML with normal karyotype and other abnormalities", or "c_ALL/Pre_B_ALL without t(9 22)" if applies}
}
}
\usage{
data(leukemiasEset)
}
\seealso{
This dataset is used in the examples on package \code{\link[geNetClassifier:geNetClassifier-package]{geNetClassifier}}. 
}
\examples{
# Load expression set:
library(leukemiasEset)
data(leukemiasEset)

# ExpressionSet overview:
leukemiasEset

# Phenodata:
pData(leukemiasEset)

# Number of samples per class:
summary(leukemiasEset$LeukemiaType)

# For adding a prefix with the disease to the sample name:
sampleNames(leukemiasEset) <- paste(leukemiasEset$LeukemiaType, 
  sampleNames(leukemiasEset), sep="_")
colnames(exprs(leukemiasEset))
}

\keyword{datasets}
\keyword{expression}
\keyword{microarrays}
\keyword{cancer}
\keyword{leukemia}
























