% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reprogramSeq.R
\name{reprogramSeq}
\alias{reprogramSeq}
\title{reprogramSeq}
\format{
\code{MultiAssayExperiment} obtained from an \code{ArchR} project.
Annotated with the hg38 genome build.
Contains the following experiments:
\itemize{
\item{\strong{TileMatrix500}: SingleCellAccessibilityExperiment with 6062095 rows and 3903 columns}
\item{\strong{GeneExpressionMatrix}: SingleCellExperiment with 36438 rows and 3903 columns}
\item{\strong{GeneScoreMatrix}: SingleCellExperiment with 24919 rows and 3903 columns}
\item{\strong{NEPCMatrix}: SingleCellExperiment with 2 rows and 3903 columns}
\item{\strong{PeakMatrix}: SingleCellExperiment with 126602 rows and 3903 columns}
\item{\strong{TF_bindingMatrix}: SingleCellExperiment with 1274 rows and 3903 columns}
}
}
\usage{
reprogramSeq(
  metadata = FALSE,
  experiments = c("TileMatrix500", "GeneExpressionMatrix", "GeneScoreMatrix",
    "NEPCMatrix", "PeakMatrix", "TF_bindingMatrix")
)
}
\arguments{
\item{metadata}{logical flag specifying whether to return data or metadata only}

\item{experiments}{character vector of matrices to return; see \code{Format}}
}
\value{
\code{MultiAssayExperiment} made up of \code{SingleCellExperiment}s
with assays stored as \code{DelayedMatrix} objects.
If \code{metadata = TRUE}, an \code{ExperimentHub} object listing this data set's metadata.
}
\description{
scMultiome data of LNCaP infected with FOXA1, NKX2-1, GATA6
}
\section{Data preparation}{


scMultiome data was processed by ArchR.
}

\section{Data storage and access}{

The \code{MultiAssayExperiments} is split into separate \code{SingleCellExperiment}
objects and they in turn are split into components, all of which are stored in a
single hdf5 file. Data and can be accessed with a special function that extracts
elements of the requested experiment(s), reassembles them, and builds an MAE.
}

\examples{
# check metada of dataset
reprogramSeq(metadata = TRUE)
# download data
\dontrun{
reprogramSeq()
}

}
\references{
Genentech dataset
}
