% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfMotifs.R
\name{tfMotifs}
\alias{tfMotifs}
\title{Transcription factor motifs}
\format{
\code{PWMatrixList} object containing information on
transcription factor motifs.
Contains the following experiments:
\itemize{
\item{\strong{human_pwms_v2}: PWMatrixList object of length 1558}
\item{\strong{mouse_pwms_v2}: PWMatrixList object of length 1558}
}
}
\usage{
tfMotifs(species = c("human", "mouse"), metadata = FALSE)
}
\arguments{
\item{species}{character string specifying the species of interest}

\item{metadata}{logical flag specifying whether to return data or metadata only}
}
\value{
A list of position weight matrices, one for each transcription factor.
}
\description{
Transcription factor motifs sets from the \code{chromVARmotifs} R package
}
\details{
This data set stores transcription factor motifs for human and
mouse genome, which can be used with the package epiregulon to compute scores of
transcription factor-regulatory element links.
}
\section{Data storage and access}{

The transcription factor motifs are stored separately for each species in .rds files encoding \code{PWMatrixList}.
Data for both species are be accessed with the same function \code{tfMotifs}.
}

\section{Data preparation}{

\subsection{1. Data download}{

Data sets were downloaded from https://github.com/GreenleafLab/chromVARmotifs/raw/master/data/ and format was changed to rds.
}

\subsection{2. Data preparation}{

The motifs were curated from the cisBP database. Position frequency matrices were converted to PWMs by taking the log of the frequencies (after adding a pseudocount of 0.008) divided by 0.25.
}

\subsection{3. Session information}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{sessionInfo()
}\if{html}{\out{</div>}}
}
}

\examples{
# check metada of dataset
tfMotifs("mouse", metadata = TRUE)
# download data
\dontrun{
tfMotifs("human")
}

}
\references{
Schep, A., Wu, B., Buenrostro, J. &  Greenleaf, W. J. (2017) chromVAR:
inferring transcription-factor-associated accessibility from single-cell
epigenomic data.
\emph{Nature Methods} 14, 975–978.
\href{http://dx.doi.org/0.1038/nmeth.4401}{doi:0.1038/nmeth.4401}
}
