% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scpdata.R
\name{scpdata}
\alias{scpdata}
\alias{scpdata-package}
\title{Single-Cell Proteomics Data Package}
\usage{
scpdata()
}
\value{
A \code{DataFrame} table containing a summary of the available
datasets.
}
\description{
The \code{scpdata} package distributes mass spectrometry-based
single-cell proteomics datasets. The datasets were collected from
published work and formatted to a standardized data framework.
The \code{scp} frameworks stores the expression data for different MS
levels (identified spectrum, peptide, or protein) in separate
assays. Each assay is an object of class \link{SingleCellExperiment}
that allows easy integration with state-of-the-art single-cell
analysis tools. All assays are contained in a single object of
class \link{QFeatures}. An overview of the data structure is shown
provided in the \code{scp} package.

The \code{scpdata()} function returns a summary table with all
currently available datasets in the package. More information
about the data content and the data collection can be found in the
corresponding manual pages.
}
\examples{
## List available datasets and their metadata 
scpdata()

## Load data using the ExperimentHub interface
hub <- ExperimentHub()

\dontrun{
## Download the data set of interest using ExperimentHub indexing
hub[["EH7711"]]
## Download the same data set using the build-in function
leduc2022()
}

}
\seealso{
More information about the data manipulation can be found
in the \code{scp} package.
}
\author{
Christophe Vanderaa
}
