% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_registered_clusters.R
\name{annotate_registered_clusters}
\alias{annotate_registered_clusters}
\title{Annotated spatially-registered clusters}
\usage{
annotate_registered_clusters(
  cor_stats_layer,
  confidence_threshold = 0.25,
  cutoff_merge_ratio = 0.25
)
}
\arguments{
\item{cor_stats_layer}{The output of \code{\link[=layer_stat_cor]{layer_stat_cor()}}.}

\item{confidence_threshold}{A \code{numeric(1)} specifying the minimum correlation
that a given cluster must have against any of the layers (by default) to
be considered as having a 'good' assignment. Otherwise, the confidence will
be 'poor' and the final label will have an asterisk.}

\item{cutoff_merge_ratio}{A \code{numeric(1)} specifying the threshold for merging
or not layer assignments (by default). This is a proportion of the difference
between the current correlation and the next highest given the units of the
next highest correlation. Defaults to a difference of 25\% of the next highest
correlation: if the observed difference is lower than this threshold, then we
keep merging. Higher values will lead to more layers (by default) being
merged.}
}
\value{
A \code{data.frame} with 3 columns. Your \code{cluster}s, the \code{layer_confidence}
which depends on \code{confidence_threshold}, and the \code{layer_label}.
}
\description{
Once you have computed the enrichment t-statistics for your sc/snRNA-seq data
using \code{registration_wrapper()} and related functions, you can then use
\code{layer_stat_cor()} and \code{layer_stat_cor_plot()} to perform the spatial
registartion of your sc/snRNA-seq data. This function helps interpret that
matrix and assign layer labels to your clusters.
}
\details{
If you change the input \code{modeling_results} to \code{layer_stat_cor()} then the
interpretation of this function could change. For example, maybe you have
your own spatially-resolved transcriptomics data that doesn't have to be
about DLPFC layers.
}
\examples{
## Obtain the necessary data
if (!exists("modeling_results")) {
    modeling_results <- fetch_data(type = "modeling_results")
}

## Compute the correlations
cor_stats_layer <- layer_stat_cor(
    tstats_Human_DLPFC_snRNAseq_Nguyen_topLayer,
    modeling_results,
    model_type = "enrichment"
)

## Obtain labels
annotate_registered_clusters(cor_stats_layer)

## More relaxed merging threshold
annotate_registered_clusters(cor_stats_layer, cutoff_merge_ratio = 1)
}
\seealso{
Other Layer correlation functions: 
\code{\link{layer_stat_cor}()},
\code{\link{layer_stat_cor_plot}()}
}
\concept{Layer correlation functions}
