% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tartare.R
\name{getFilename}
\alias{getFilename}
\alias{tartare}
\title{downloads files from aws storage and returns local filepath}
\usage{
getFilename(eh, query = c("tartare"))
}
\arguments{
\item{eh}{ExperimentHub object.}

\item{query}{a query string, e.g.,
\code{c('tartar', '20190710_003_PierceHeLaProteinDigestStd.raw')}}
}
\value{
returns file(s) contained in the tartare package.
}
\description{
calls the \code{\link{query}} method of an
\code{\link{ExperimentHub}}
object query and returns the local filenames.
Of note: for proprietary reasons, a \code{\link{file.link}} is
set to the cached files.
It seems that the New RawfileReader .Net library is only accepting files
ending with raw.
The overall file size is 285MB.
}
\examples{
library(ExperimentHub)
eh <- ExperimentHub()
query(eh, c('tartare'))

\dontrun{
(files <- getFilename(eh))
library(MsBackendRawFileReader)

be <- lapply(files, function(f){
if (grepl("mzXML$", f))
    backendInitialize(MsBackendMzR(), files = f)
else
    backendInitialize(MsBackendRawFileReader(), files = f, extra=FALSE)
})
}

\dontrun{
hfx.filename <- .query(eh, c('tartar', '20190710_003_PierceHeLaProteinDigestStd.raw'))
x <- .cnew ("Rawfile", hfx.filename)
x$GetInfoValues()
}

}
\seealso{
\itemize{
\item {\code{browseVignettes('tartare')}}
\item {\code{\link{query}}}
}
}
\author{
Christian Panse <cp@fgcz.ethz.ch>, 2019-10
}
